using System;

namespace Team_Project
{
	/// <summary>
	/// Attributo utilizzato per ottenere alcune informazioni sull'utilizzo di
	/// un'istanza della classe alla quale  applicato come oggetto globale.
	/// </summary>
	/// <remarks>Questo attributo pu essere applicato ad una classe.
	/// Se questa classe viene inserita in un opportuno file di configurazione
	/// letto dall'engine, questo attriubuto fornisce le informazioni necessarie
	/// alla suo utilizzo.</remarks>
	[AttributeUsage(AttributeTargets.Class)]
	[Serializable]
	public class TeamProjectInitAttribute : Attribute
	{
		private bool toDispose = false;
		private string name = null;

		/// <summary>
		/// Utilizza i valori di default false per dispose e null per name
		/// </summary>
		public TeamProjectInitAttribute():this(false,null){}
		/// <summary>
		/// Utilizza il valore di default null per name.
		/// Se dipose viene impostato a true l'engine chiamer il metodo Dispose
		/// sull'istanza generata alla chiusura del servizio
		/// </summary>
		/// <param name="dispose">true se l'istanza necessita di rilasciare risorse alla chiusura</param>
		public TeamProjectInitAttribute(bool dispose):this(dispose,null){}
		/// <summary>
		/// Utilizza il valore di default false per dispose.
		/// Se name  diverso da null l'oggetto istanza della classe su cui l'attributo 
		///  applicato sar reso globale.
		/// </summary>
		/// <param name="name">Nome con il quale si desidera rendere globale l'istanza dell'oggetto</param>
		public TeamProjectInitAttribute(string name):this(false,name){}

		/// <summary>
		/// Costruisce un attirbuto utilizzato dall'engine.
		/// </summary>
		/// <remarks>Se dipose viene impostato a true l'engine chiamer il metodo Dispose
		/// sull'istanza generata alla chiusura del servizio.
		/// Se name  diverso da null l'oggetto istanza della classe su cui l'attributo 
		///  applicato sar reso globale.</remarks>
		/// <param name="dipose">true se l'istanza necessita di rilasciare risorse alla chiusura</param>
		/// <param name="name">Nome con il quale si desidera rendere globale l'istanza dell'oggetto</param>
		public TeamProjectInitAttribute(bool dipose,string name)
		{
			toDispose = dipose;
			this.name = name;
		}

		/// <summary>
		/// Restitusce un booleano che indica se l'oggetto alla quale  applicato
		/// deve essere distrutto al termine del servizio
		/// </summary>
		public bool ToDispose
		{
			get{return toDispose;}
		}

		/// <summary>
		/// Restituisce il nome con il quale l'oggetto  ottenibile globalmente,
		/// oppure null se tale oggetto non  un singleton globale
		/// </summary>
		public string Name
		{
			get{return name;}
		}

		/// <summary>
		/// Restituisce un booleano che indica se l'oggetto dev'essere visto 
		/// globalmente
		/// </summary>
		public bool PutInGlobal
		{
			get{return name!=null;}
		}
	}
}
